/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import java.nio.file.Path;
import java.util.Date;
import java.util.Set;
import org.sonar.api.utils.TempFolder;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.connected.update.GlobalPropertiesDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.ModuleListDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.PluginReferencesDownloader;
import org.sonarsource.sonarlint.core.container.connected.update.RulesDownloader;
import org.sonarsource.sonarlint.core.container.connected.validate.ServerVersionAndStatusChecker;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.container.storage.StorageManager;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.FileUtils;
import org.sonarsource.sonarlint.core.util.VersionUtils;

public class GlobalUpdateExecutor {
    private final StorageManager storageManager;
    private final PluginReferencesDownloader pluginReferenceDownloader;
    private final GlobalPropertiesDownloader globalPropertiesDownloader;
    private final RulesDownloader rulesDownloader;
    private final TempFolder tempFolder;
    private final ModuleListDownloader moduleListDownloader;
    private final ServerVersionAndStatusChecker statusChecker;
    private final SonarLintWsClient wsClient;

    public GlobalUpdateExecutor(StorageManager storageManager, SonarLintWsClient wsClient, ServerVersionAndStatusChecker statusChecker, PluginReferencesDownloader pluginReferenceDownloader, GlobalPropertiesDownloader globalPropertiesDownloader, RulesDownloader rulesDownloader, ModuleListDownloader moduleListDownloader, TempFolder tempFolder) {
        this.storageManager = storageManager;
        this.wsClient = wsClient;
        this.statusChecker = statusChecker;
        this.pluginReferenceDownloader = pluginReferenceDownloader;
        this.globalPropertiesDownloader = globalPropertiesDownloader;
        this.rulesDownloader = rulesDownloader;
        this.moduleListDownloader = moduleListDownloader;
        this.tempFolder = tempFolder;
    }

    public void update() {
        Sonarlint.ServerInfos serverStatus = this.statusChecker.checkVersionAndStatus();
        Path temp = this.tempFolder.newDir().toPath();
        ProtobufUtil.writeToFile(serverStatus, temp.resolve("server_info.pb"));
        Set<String> allowedPlugins = this.globalPropertiesDownloader.fetchGlobalPropertiesTo(temp);
        this.pluginReferenceDownloader.fetchPluginsTo(temp, allowedPlugins);
        this.rulesDownloader.fetchRulesTo(temp);
        this.moduleListDownloader.fetchModulesList(temp);
        Sonarlint.UpdateStatus updateStatus = Sonarlint.UpdateStatus.newBuilder().setClientUserAgent(this.wsClient.getUserAgent()).setSonarlintCoreVersion(VersionUtils.getLibraryVersion()).setUpdateTimestamp(new Date().getTime()).build();
        ProtobufUtil.writeToFile(updateStatus, temp.resolve("update_status.pb"));
        Path dest = this.storageManager.getGlobalStorageRoot();
        FileUtils.deleteDirectory(dest);
        FileUtils.forceMkDirs(dest.getParent());
        FileUtils.moveDir(temp, dest);
    }
}

